<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class UpdatedCartItemEvent extends Event
{
	public function __construct(
		public string $itemId,
		public int    $quantity,
		public int    $beforeQuantity,
		public array  $moreData = [],
		public ?int   $productId = null,
	)
	{
	}
}
