<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Contributte\Events\Extra\Event\Security\LoggedInEvent;
use Contributte\Events\Extra\Event\Security\LoggedOutEvent;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\FrontModule\Model\CartFacade;
use Exception;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class ApplicationSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected CartFacade             $cartFacade,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			LoggedInEvent::class  => 'loggedIn',
			LoggedOutEvent::class => 'loggedOut',
		];
	}

	public function loggedIn(LoggedInEvent $event): void
	{
		try {
			$this->cartFacade->mergeCartToUserCart((int) $event->getUser()->getId());
		} catch (Exception $e) {
			Debugger::log($e, Debugger::ERROR);
		}
	}

	public function loggedOut(LoggedOutEvent $event): void
	{
		$this->cartFacade->getCartsService()->unsetCart();
	}
}
