<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Security\User as SUser;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\UserManager;

class OrderNewUserSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $entityManager,
		protected SUser                  $sUser,
		protected UserManager            $userManager,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => 'orderOnSuccess',
		];
	}

	public function orderOnSuccess(OrderEvent $orderEvent): void
	{
		if (!$this->sUser->isLoggedIn() && EshopOrdersConfig::load('orderForm.newUserEmailNotificationAfterOrder')) {
			$this->userManager->newUserEmailNotification($orderEvent->order->getCustomer()->getUser()->getId());
		}
	}
}
