<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\FrontModule\Model\Affiliate;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopOrders\Model\EshopOrdersConfig;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderSubscriber implements EventSubscriberInterface
{
	public static bool $enableSendInvoice = false;

	public function __construct(
		protected Translator             $translator,
		protected EntityManagerDecorator $em,
		protected Affiliate              $affiliate,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => 'orderOnSuccess',
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		if (!EshopOrdersConfig::load('affiliate.enable')) {
			return;
		}

		$affiliateData = $this->affiliate->checkCookie();
		if ($affiliateData && isset($affiliateData['campaignId'])) {
			$this->affiliate->addOrder((int) $affiliateData['campaignId'], $event->order);
		}
	}
}
