<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use EshopOrders\FrontModule\Model\Customers;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Event\UserEvent;

class RegisterFormSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Customers $customers,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'users.registerForm.afterSave' => 'afterSave',
		];
	}

	public function afterSave(UserEvent $event): void
	{
		$user = $event->user;
		$this->customers->getOrCreateCustomer($user->getId(), $user->getEmail(), $user->getName(), $user->getLastname());
	}
}
