<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191223192323 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__order ADD site_id VARCHAR(255) DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__order ADD CONSTRAINT FK_2888C07E2999F1FD FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE SET NULL');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$siteId = $this->connection->fetchOne('SELECT ident FROM core__site LIMIT 1');

		$this->connection->update('eshop_orders__order', [
			'site_id' => $siteId,
		], [
			'site_id' => null,
		]);
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__order DROP FOREIGN KEY FK_2888C07E2999F1FD');
		$this->addSql('ALTER TABLE eshop_orders__order DROP site_id');
	}
}
