<?php

declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200314160437 extends AbstractMigration
{
	protected static array $psSites = [];

	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		self::$psSites = $this->connection->fetchAllAssociative("SELECT id, site_id FROM eshop_orders__payment_spedition");

		$this->addSql('CREATE TABLE eshop_orders__payment_spedition_site (ps_id INT NOT NULL, site_id VARCHAR(255) NOT NULL, INDEX IDX_593F1BDDDF7A0482 (ps_id), INDEX IDX_593F1BDDF6BD1646 (site_id), PRIMARY KEY(ps_id, site_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_orders__payment_spedition_site ADD CONSTRAINT FK_593F1BDDDF7A0482 FOREIGN KEY (ps_id) REFERENCES eshop_orders__payment_spedition (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__payment_spedition_site ADD CONSTRAINT FK_593F1BDDF6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__payment_spedition DROP FOREIGN KEY FK_108548CBF6BD1646');
		$this->addSql('DROP INDEX IDX_108548CBF6BD1646 ON eshop_orders__payment_spedition');
		$this->addSql('ALTER TABLE eshop_orders__payment_spedition DROP site_id');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach (self::$psSites as $v) {
			$this->connection->insert('eshop_orders__payment_spedition_site', [
				'ps_id'   => $v['id'],
				'site_id' => $v['site_id'],
			]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_orders__payment_spedition_site');
		$this->addSql('ALTER TABLE eshop_orders__payment_spedition ADD site_id VARCHAR(255) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`');
		$this->addSql('ALTER TABLE eshop_orders__payment_spedition ADD CONSTRAINT FK_108548CBF6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE CASCADE');
		$this->addSql('CREATE INDEX IDX_108548CBF6BD1646 ON eshop_orders__payment_spedition (site_id)');
	}
}
