<?php declare(strict_types = 1);

namespace EshopOrders\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20260108142416 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_orders__customer_loyalty (points INT DEFAULT 0 NOT NULL, last_activity_at DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, email_expire_sent DATETIME DEFAULT NULL, id INT UNSIGNED AUTO_INCREMENT NOT NULL, customer_id INT NOT NULL, site_id VARCHAR(255) NOT NULL, INDEX IDX_937E14E59395C3F3 (customer_id), INDEX IDX_937E14E5F6BD1646 (site_id), UNIQUE INDEX customer_site_idx (customer_id, site_id), PRIMARY KEY (id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_orders__customer_loyalty_action (created_at DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, points INT NOT NULL, reason VARCHAR(32) NOT NULL, reference_id INT DEFAULT NULL, note LONGTEXT DEFAULT NULL, id INT UNSIGNED AUTO_INCREMENT NOT NULL, customer_loyalty_id INT UNSIGNED NOT NULL, INDEX IDX_9E37B2C834CF718F (customer_loyalty_id), PRIMARY KEY (id)) DEFAULT CHARACTER SET utf8');
		$this->addSql('ALTER TABLE eshop_orders__customer_loyalty ADD CONSTRAINT FK_937E14E59395C3F3 FOREIGN KEY (customer_id) REFERENCES eshop_orders__customer (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__customer_loyalty ADD CONSTRAINT FK_937E14E5F6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_orders__customer_loyalty_action ADD CONSTRAINT FK_9E37B2C834CF718F FOREIGN KEY (customer_loyalty_id) REFERENCES eshop_orders__customer_loyalty (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_orders__customer_loyalty DROP FOREIGN KEY FK_937E14E59395C3F3');
		$this->addSql('ALTER TABLE eshop_orders__customer_loyalty DROP FOREIGN KEY FK_937E14E5F6BD1646');
		$this->addSql('ALTER TABLE eshop_orders__customer_loyalty_action DROP FOREIGN KEY FK_9E37B2C834CF718F');
		$this->addSql('DROP TABLE eshop_orders__customer_loyalty');
		$this->addSql('DROP TABLE eshop_orders__customer_loyalty_action');
	}
}
