<?php declare(strict_types = 1);

namespace EshopOrders\Model\Cache;

use Core\Model\Sites;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class LoyaltyCache
{
	public const string cacheLoyalty     = 'eshopOrdersLoyalty';
	public const string cacheKeySettings = 'settings';
	public const string cacheKeyCustomer = 'customer';

	public readonly Cache $cache;

	public function __construct(
		protected Storage $storage,
		protected Sites   $sites,
	)
	{
		$this->cache = new Cache($this->storage, self::cacheLoyalty);
	}

	public function clearSettings(): void
	{
		foreach ($this->sites->getSites() as $site) {
			$this->cache->remove(self::getSettingsKey($site->getIdent()));
		}
	}

	public function clearAll(): void
	{
		$this->cache->clean();
	}

	public function clearCustomer(int $customerId, string $siteIdent): void
	{
		$this->cache->remove(self::getCustomerKey($customerId, $siteIdent));
	}

	public static function getCustomerKey(int $customerId, string $siteIdent): string { return self::cacheKeyCustomer . ':' . $siteIdent . ':' . $customerId; }

	public static function getSettingsKey(string $siteIdent): string { return self::cacheKeySettings . ':' . $siteIdent; }
}
