<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Affiliate;

use Core\Model\Entities\TIdUnsigned;
use Core\Model\Helpers\Strings;
use DateTime;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Order;

#[ORM\Table('eshop_orders__affiliate_order')]
#[ORM\Entity]
class AffiliateOrder
{
	use TIdUnsigned;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', nullable: false)]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	public Order $order;

	#[ORM\JoinColumn(name: 'campaign_id', referencedColumnName: 'id', nullable: false)]
	#[ORM\ManyToOne(targetEntity: AffiliateCampaign::class, inversedBy: 'orders')]
	public AffiliateCampaign $campaign;

	#[ORM\Column(name: 'created', type: Types::DATE_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public DateTime $created;

	/**
	 * @var float|string
	 */
	#[ORM\Column(name: 'price', type: Types::DECIMAL, precision: 10, scale: 2, options: ['default' => 0])]
	public $value = 0;

	/**
	 * @var float|string
	 */
	#[ORM\Column(name: 'order_value', type: Types::DECIMAL, precision: 10, scale: 2, options: ['default' => 0])]
	public $orderValue = 0;

	#[ORM\Column(name: 'email', type: Types::STRING, nullable: true)]
	public ?string $email = null;

	#[ORM\Column(name: 'cancelled', type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $cancelled = null;

	public function __construct(Order $order, AffiliateCampaign $campaign, float $value, float $orderValue)
	{
		$this->order      = $order;
		$this->campaign   = $campaign;
		$this->created    = new DateTime();
		$this->value      = Strings::formatEntityDecimal($value);
		$this->orderValue = Strings::formatEntityDecimal($orderValue);
	}
}

