<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

#[ORM\Table(name: 'eshop_orders__carrier_history')]
#[ORM\Entity]
class CarrierHistory
{
	use TId;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $speditionName;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $numberPackage;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false)]
	public \DateTime $created;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	public Order $order;

	public function __construct(Order $order, string $speditionName, ?string $numberPackage)
	{
		$this->order         = $order;
		$this->speditionName = $speditionName;
		$this->numberPackage = $numberPackage;
		$this->created       = new DateTime;
	}

}
