<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\Site;
use Core\Model\Entities\TIdUnsigned;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_orders__customer_loyalty')]
#[ORM\UniqueConstraint(name: 'customer_site_idx', columns: ['customer_id', 'site_id'])]
#[ORM\Entity]
class CustomerLoyalty
{
	use TIdUnsigned;

	#[ORM\ManyToOne(targetEntity: Customer::class)]
	#[ORM\JoinColumn(name: 'customer_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	public Customer $customer;

	#[ORM\ManyToOne(targetEntity: Site::class)]
	#[ORM\JoinColumn(name: 'site_id', referencedColumnName: 'ident', nullable: false, onDelete: 'CASCADE')]
	public Site $site;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['default' => 0])]
	public int $points = 0;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public DateTime $lastActivityAt;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $emailExpireSent = null;

	/** @var Collection<CustomerLoyaltyAction> */
	#[ORM\OneToMany(targetEntity: CustomerLoyaltyAction::class, mappedBy: 'customerLoyalty')]
	public Collection $actions;

	public function __construct(Customer $customer, Site $site, DateTime $lastActivityAt = new DateTime(), int $points = 0)
	{
		$this->customer       = $customer;
		$this->site           = $site;
		$this->lastActivityAt = $lastActivityAt;
		$this->points         = $points;
		$this->actions        = new ArrayCollection;
	}

}
