<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use DateTime;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_orders__customer_loyalty_action', indexes: [
	new ORM\Index(name: 'idx_cla_created', columns: ['created_at']),
])]
#[ORM\Entity]
class CustomerLoyaltyAction
{
	use TIdUnsigned;

	#[ORM\ManyToOne(targetEntity: CustomerLoyalty::class, inversedBy: 'actions')]
	#[ORM\JoinColumn(name: 'customer_loyalty_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	public CustomerLoyalty $customerLoyalty;

	#[ORM\Column(name: 'created_at', type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public DateTime $createdAt;

	#[ORM\Column(type: Types::INTEGER, nullable: false)]
	public int $points;

	#[ORM\Column(type: Types::STRING, length: 32, nullable: false)]
	public string $reason;

	#[ORM\Column(type: Types::INTEGER, nullable: true)]
	public ?int $referenceId = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $note = null;

	public function __construct(CustomerLoyalty $customerLoyalty, DateTime $createdAt, int $points, string $reason)
	{
		$this->customerLoyalty = $customerLoyalty;
		$this->createdAt       = $createdAt;
		$this->points          = $points;
		$this->reason          = $reason;
	}

}
