<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__invoice_address')]
#[ORM\Entity]
class Address
{
	use TId;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $street = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $city = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $postal = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $country = null;

	#[ORM\Column(name: 'country_code', type: Types::STRING, length: 2, nullable: true)]
	public ?string $countryCode = null;

}
