<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__invoice_bank')]
#[ORM\Entity]
class Bank
{
	use TId;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $iban = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $swift = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $variableSymbol = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $bankCode = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $bankAccount = null;

	#[ORM\Column(name: 'note', type: Types::STRING, length: 255, nullable: true)]
	public ?string $note = null;

}
