<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__order_currency')]
#[ORM\Entity]
class OrderCurrency
{

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\OneToOne(inversedBy: 'currency', targetEntity: Order::class)]
	protected Order $order;

	#[ORM\Column(name: 'code', type: Types::STRING, length: 3, nullable: false, options: ['default' => 'CZK'])]
	public string $code = 'CZK';

	/**
	 * @var float|string
	 */
	#[ORM\Column(name: 'rate', type: Types::DECIMAL, precision: 10, scale: 5, nullable: false, options: ['default' => 1])]
	public $rate;

	#[ORM\Column(name: 'decimals', type: Types::INTEGER, nullable: false, options: ['default' => 0])]
	public int $decimals = 0;

	public function __construct(Order $order, string $code)
	{
		$this->order    = $order;
		$this->code     = $code;
		$this->rate     = 1;
		$this->decimals = 0;
	}

	public function getOrder(): Order { return $this->order; }
}
