<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_orders__order_item_texts')]
#[ORM\Entity]
class OrderItemTexts
{

	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: OrderItem::class, cascade: ['persist', 'remove'], inversedBy: 'OrderItemTexts')]
	protected OrderItem $id;

	#[ORM\Id]
	#[ORM\Column(name: 'lang', type: Types::STRING, length: 2)]
	protected string $lang;

	#[ORM\Column(name: 'name', type: Types::STRING, length: 255)]
	protected ?string $name = null;

	public function __construct(OrderItem $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getLang(): string { return $this->lang; }

	public function getName(): ?string { return $this->name; }

	public function setName(?string $name): OrderItemTexts
	{
		$this->name = $name;

		return $this;
	}

	public function setId(OrderItem $id): void { $this->id = $id; }
}

