<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Seller;

#[ORM\Table('eshop_orders__seller_invoice_config')]
#[ORM\Entity]
class SellerInvoiceConfig
{
	use TId;

	#[ORM\JoinColumn(name: 'seller_invoice_config_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: InvoiceConfig::class, inversedBy: 'sellerInvoiceConfigs')]
	public InvoiceConfig $invoiceConfig;

	#[ORM\JoinColumn(name: 'seller_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\OneToOne(targetEntity: Seller::class)]
	public Seller $seller;

	public function __construct(InvoiceConfig $invoiceConfig, Seller $seller)
	{
		$this->invoiceConfig = $invoiceConfig;
		$this->seller        = $seller;
	}
}
