<?php declare(strict_types = 1);

namespace EshopOrders\Model\Event;

use Core\Model\Templating\Template;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use Nette\Mail\Message;
use Nette\Utils\Html;
use Symfony\Contracts\EventDispatcher\Event;

class EmailEvent extends Event
{
	public function __construct(
		public Template     $template,
		public Message      $message,
		public Order        $order,
		public ?string      $status = null,
		public ?OrderStatus $orderStatus = null,
	)
	{
	}

	public function addCustomHtml(Html $html): void
	{
		if (!property_exists($this->template, 'customHtml') || $this->template->customHtml === null) {
			$this->template->customHtml = Html::el('div');
		}

		$this->template->customHtml->addHtml($html);
	}
}
