<?php declare(strict_types = 1);

namespace EshopOrders\Model\Event;

use Core\Model\UI\AbstractPresenter;
use EshopOrders\Model\Entities\Order;
use Symfony\Contracts\EventDispatcher\Event;

class OrderStatusEvent extends Event
{
	public ?AbstractPresenter $presenter = null;

	public function __construct(
		public Order  $order,
		public string $status,
	)
	{
	}
}
