<?php declare(strict_types = 1);

namespace EshopOrders\Model\Helpers;

use Core\Model\Helpers\Strings;
use EshopCatalog\FrontModule\Model\Dao\Seller;
use EshopOrders\Model\Entities\Order;
use Rikudou\CzQrPayment\QrPayment;
use Rikudou\Iban\Iban\CzechIbanAdapter;
use Rikudou\Iban\Iban\IBAN;

class QrGenerator
{
	public function createQrCode(
		string  $bankAccount,
		string  $bankCode,
		string  $variableSymbol,
		float   $amount,
		string  $currency,
		?string $iban = null,
		bool    $instantPayment = true
	): QrPayment
	{
		$qrPayment = new QrPayment(new CzechIbanAdapter($bankAccount, $bankCode));
		$qrPayment->setVariableSymbol($variableSymbol)
			->setAmount(round($amount, 2))
			->setCurrency(Strings::upper($currency))
			->setInstantPayment($instantPayment);

		if ($iban) {
			$qrPayment->setIban(new IBAN($iban));
		}

		return $qrPayment;
	}

	public function getQrCodeByOrderAndSeller(Order $order, Seller $seller, ?string $variableSymbol = null): ?QrPayment
	{
		$bankAccount = $seller->getBankAccount($order->getCurrencyCode());

		if (!$bankAccount || !$bankAccount->numberPart1 || !$bankAccount->numberPart2) {
			return null;
		}

		return $this->createQrCode(
			$bankAccount->numberPart1,
			$bankAccount->numberPart2,
			$variableSymbol ?: ((string) $order->getId()),
			$order->getPrice(true),
			$order->getCurrencyCode(),
			$bankAccount->iban
		);
	}
}
