<?php declare(strict_types = 1);

namespace EshopOrders\Model\Listeners;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Entities\CustomerAddress;
use Nette\Utils\DateTime;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class UserListener implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @param Customer|CustomerAddress $entity
	 */
	#[ORM\PostUpdate]
	public function preUpdate(object $entity, LifecycleEventArgs $args): void
	{
		$userIds = [];
		if ($entity instanceof Customer) {
			$userId[] = $entity->user->getId();
		} else if ($entity instanceof CustomerAddress) {
			foreach ($entity->customers as $c) {
				$userIds[] = $c->user->getId();
			}
		}

		if ($userIds !== []) {
			$this->em->getConnection()->executeQuery(
				"UPDATE user SET last_modified = :datetime WHERE id IN (" . implode(',', $userIds) . ")", [
				'datetime' => (new DateTime())->format('Y-m-d H:i:s'),
			]);
		}
	}
}
