<?php declare(strict_types = 1);

namespace EshopOrders\Model\Loyalty;

class LoyaltyCalculator
{
	public function __construct(
		protected LoyaltySettings $loyaltySettings,
	)
	{
	}

	public function calculate(float $orderValue, string $sideIdent): int
	{
		$loyaltySettings = $this->loyaltySettings->getSettings($sideIdent);
		if (!$loyaltySettings) {
			return 0;
		}

		// kolikanasobek potrebneho poctu bodu
		$pointCount = $orderValue / $loyaltySettings->wholeMoneyValueForPoint;

		//zaokrouhleni na 10 desetinnych mist - snad ochrana (podobne jako epsilon) proti omezene presnosti floatu, aby se nestalo, ze po deleni zikame napriklad cislo 1.99999999999, ktere ma ale ve skutecnosti byt spravne 2
		$pointCount = round($pointCount, 10);

		//pouze za kazdy CELY nasobek;
		$pointCount = (int) floor($pointCount);

		//kolik bodu za kazdych X korun
		return (int) floor($pointCount * $loyaltySettings->pointsForWholeMoney);
	}
}
