<?php declare(strict_types = 1);

namespace EshopOrders\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Orders;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Override;

class OrderItemReviews extends BaseNavigation implements INavigationItem
{
	protected $title     = 'orderItemReviews';
	protected $presenter = 'EshopOrders:Front:OrderItemReviews';
	protected $action    = 'giveReviews';

	public function __construct(
		protected Orders $ordersService,
	)
	{
	}

	#[Override]
	public function getFormContainer(BaseForm $form): BaseContainer
	{
		return new BaseContainer();
	}

	#[Override]
	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	#[Override]
	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action) {
			return 1;
		}

		return false;
	}

	#[Override]
	public function routerIn($navigation, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	#[Override]
	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		$urlParts = [];
		if (!$navigation->isHomepage) {
			$urlParts[] = $navigation->alias;
		}

		return '/' . implode('/', $urlParts);
	}
}
