<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\ProductPriceLevel;
use EshopOrders\Model\Helpers\EshopOrdersCache;

/**
 * @method ProductPriceLevel|object|null getReference($id)
 * @method ProductPriceLevel|null get($id)
 */
class ProductsPriceLevel extends BaseEntityService
{
	protected $entityClass = ProductPriceLevel::class;

	public function __construct(
		protected EshopOrdersCache $eshopOrdersCache,
	)
	{
	}

	public function getPricesForGroup(array $ids, int $groupId): array
	{
		$arr = [];

		foreach (array_chunk($ids, 500) as $chunk) {
			$query = $this->em->getRepository(ProductPriceLevel::class)->createQueryBuilder('ppl')
				->select('IDENTITY(ppl.productId) as product, ppl.price')
				->where('ppl.productId IN (' . implode(',', array_values($chunk)) . ')')
				->andWhere('ppl.groupId = :groupId')
				->setParameters(new ArrayCollection([new Parameter('groupId', $groupId)]))
				->getQuery();

			$resultCache = Config::loadInt('productsList.enableFreshResultCache') ?: 0;
			if ($resultCache) {
				$query->setQueryCacheLifetime($resultCache);
				$query->enableResultCache($resultCache);
			}

			foreach ($query->getArrayResult() as $row) {
				$arr[$row['product']] = (float) $row['price'];
			}
		}

		return $arr;
	}
}
