<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	public function __construct(
		protected RouteHelper $routeHelper,
	)
	{
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('EshopOrders:Front');
		$front[] = $this->routeHelper->createRoute('/eshoporders/payment/pay', 'Payment:pay');
		$front[] = $this->routeHelper->createRoute('/eshoporders/payment/qr-code', 'Payment:qrCode');
		$front[] = $this->routeHelper->createRoute('/eshoporders/customer/invoice/<id>', 'Customer:invoice');

		return $router;
	}
}
