document.addEventListener('change', e => {
	const target = e.target;

	if (target.id === 'invoiceAddressValidatedIdNumber') {
		global.naja.makeRequest('get', target.dataset.link.replace('__val__', target.checked ? 1 : 0), {}, {
			history: false,
			forceRedirect: true,
		});
	} else if (target.id === 'invoiceAddressValidatedVatNumber') {
		global.naja.makeRequest('get', target.dataset.link.replace('__val__', target.checked ? 1 : 0), {}, {
			history: false,
			forceRedirect: true,
		});
	}

	if (document.querySelector('[data-external-invoice-hint]')) {
		if (target.id === 'frm-orderStatusForm-form-status') {
			const choice = global.choicesList[document.querySelector('select#frm-orderStatusForm-form-status').dataset.choicesIndex]
			const externalInvoiceHint = document.querySelector('[data-external-invoice-hint]')
			externalInvoiceHint.style.display = ['spedition', 'finished'].includes(choice.getValue(true)) ? 'block' : 'none'
		}
	}
})

document.addEventListener('DOMContentLoaded', e => {
	document.addEventListener('click', e => {
		if (e.target.classList.contains('quick-edit-form-submit') && e.target.form) {
			const form = e.target.form
			const duzpControl = form.querySelector('input[name=duzp]')
			const defaultDuzpYearControl = form.querySelector('input[name=defaultDUZPYear]')
			const defaultDuzpMonthControl = form.querySelector('input[name=defaultDUZPMonth]')
			let confirm = true

			if (!window.Nette.validateForm(form, false)) {
				return false
			}

			if (duzpControl && defaultDuzpYearControl && defaultDuzpMonthControl && (duzpControl.dataset.validateYear || duzpControl.dataset.validateMonth)) {
				const month = Number.parseInt(duzpControl.value.replaceAll(' ', '').split('.')[1])
				const year = Number.parseInt(duzpControl.value.replaceAll(' ', '').split('.')[2])
				const defaultDuzpYear = Number.parseInt(defaultDuzpYearControl.value)
				const defaultDuzpMonth = Number.parseInt(defaultDuzpMonthControl.value)

				if (duzpControl.dataset.validateYear && year !== defaultDuzpYear && year && defaultDuzpYear) {
					confirm = window.confirm('Přesouváte DUZP do jiného roku, může dojít k díře v čís. řadě. Pokračovat?')
				} else if (duzpControl.dataset.validateMonth && month !== defaultDuzpMonth && month && defaultDuzpMonth) {
					confirm = window.confirm('Přesouváte DUZP do jiného roku či měsíce, může dojít k díře v čís. řadě. Pokračovat?')
				}
			}

			if (confirm) {
				global.naja.makeRequest('post', form.action, new FormData(form), {history: false,})
			}
		}
	})
})

const initExpeditionForm = () => {
	const form = document.getElementById('frm-orderForm-expeditionForm')
	if (!form || form.dataset.ajaxInit) {
		return
	}

	form.dataset.ajaxInit = true

	form.addEventListener('submit', ev => {
		ev.preventDefault()
		if (!window.Nette.validateForm(form, false)) {
			return false
		}

		const event = new CustomEvent('orderForm:expeditionForm:submit', {detail: {form, submitForm: true}})
		document.dispatchEvent(event)

		if (event.detail.submitForm) {
			global.naja.uiHandler.submitForm(form, {forceRedirect: true})
		}
	})
}

document.addEventListener('DOMContentLoaded', e => {
	initExpeditionForm()
	global.naja.addEventListener('complete', initExpeditionForm)
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initExpeditionForm()
	})
})