if (!global.document.autocompleteResultItem)
	global.document.autocompleteResultItem = {};

global.document.autocompleteResultItem['orderItemAddForm-product'] = (data, source) => {
	source.innerHTML = data.value.code1 + ' | ' + data.value.name;
};

const form  = document.querySelector('.orderItemAddForm');

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name == 'orderItemAddForm-product') {
		const input = document.querySelector('[data-autocomplete-name="' + e.detail.name + '"]');
		const data  = e.detail.selection.value;

		if (form) {
			form.querySelector('[name="code1"]').value = data.code1;

			global.naja.makeRequest('get', input.dataset.detailLink.replace('__id__', data.id), {}, {
				history: false
			}).then(response => {
				const priceEl = form.querySelector('[name="price"]');
				priceEl.value       = response.price;
				form.querySelector('[name="productName"]').value = response.name;
				form.querySelector('[name="vatRate"]').value     = response.vatRate;

				priceEl.dispatchEvent(new Event('change'));
			});
		}
	}
});

const productInput = document.getElementById('frm-orderItemAddForm-form-product');

if (productInput) {
	productInput.setAttribute('tab-index', '0');

	setTimeout(() => {
		productInput.focus();
	}, 300);
}

if (form) {
	const priceControl = form.querySelector('[name="price"]');
	const currencyRateControl = form.querySelector('[name="currencyPrice"]');
	if (currencyRateControl && priceControl) {
		let rate = currencyRateControl.dataset.rate.replace(',', '.');

		if (rate) {
			rate = rate.replace(',', '.');
			rate = parseFloat(rate);

			function updatePrice() {
				let price = priceControl.value.replace(',', '.');
				price     = parseFloat(price);

				currencyRateControl.value = Math.round((price / rate) * 100) / 100;
			}
			
			priceControl.addEventListener('change', updatePrice)
			priceControl.addEventListener('keyup', updatePrice)
		}
	}
}
