document.addEventListener('DOMContentLoaded', () => {
});

global.naja.addEventListener('complete', e => {
	initCalculateCurrencies();
});

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	initCalculateCurrencies();
});

const initCalculateCurrencies = () => {
	const formEl = document.querySelector('[id*="speditionsGrid-form-form"]');
	if (!formEl) {
		return;
	}

	const wrap       = formEl.querySelector('.price-in-other-currencies');
	const valueEl    = formEl.querySelector('[name="price"]');
	const freeFromEl = formEl.querySelector('[name="freeFrom"]');

	if (!wrap || !valueEl || !freeFromEl) {
		return;
	}

	const data = JSON.parse(wrap.dataset.data);

	function change() {
		let tableRows = '';

		function addRow(site, currency, price, freeFrom) {
			tableRows += '<tr><td>' + site + '</td><td>' + currency + '</td><td style="text-align: right">' + price.toFixed(2) + '</td><td style="text-align: right">' + freeFrom.toFixed(2) + '</td></tr>';
		}

		for (let site in data) {
			let currencies = data[site];

			for (let curr in currencies) {
				let item = currencies[curr];

				addRow(site, curr, valueEl.value / item.rate, freeFromEl.value / item.rate);
			}
		}

		wrap.innerHTML = '<table style="width: 100%">' + tableRows + '</table>';
	}

	change();
	valueEl.addEventListener('keyup', change);
	freeFromEl.addEventListener('keyup', change);
}
