<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Core\Model\Templating\Filters\Price as PriceFilter;
use Currency\Model\Currencies;
use Dashboard\AdminModule\Components\Widget;

abstract class BaseEshopOrdersWidget extends Widget
{
	/** @var Currencies|null @inject */
	public ?Currencies $currencies = null;

	/** @var PriceFilter|null @inject */
	public ?PriceFilter $priceFilter = null;

	protected string $baseTemplate = __DIR__ . '/baseCount.latte';

	protected function getCurrencySymbol(): string { return (string) $this->currencies->getAll()[$this->currencies->getDefaultCode()]->symbol ?: 'Kč'; }
}
