<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;

class OrdersCount extends BaseEshopOrdersWidget implements IWidget
{
	protected string $gridSize = 'col-md-4 col-xxl-3';

	protected string $key = 'eshopOrdersOrdersCount';

	/** @var Statistics\Overview|null @inject */
	public ?Statistics\Overview $overview = null;

	public function render(): void
	{
		if (!$this->loggedUser->isAllowed('EshopOrders:Admin', 'access')) {
			return;
		}

		$this->template->key   = $this->key;
		$this->template->icon  = 'fas fa-shopping-cart';
		$this->template->title = $this->t('eshopOrders.dashboardWidget.ordersCount.title');

		$data                    = $this->overview->getOrdersCount();
		$this->template->value   = number_format($data['count'], 0, '', ' ');
		$this->template->percent = $data['percent'];

		$this->template->baseTemplate = $this->baseTemplate;
		$this->template->render($this->getTemplateFile());
	}
}
