<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components;

use Core\AdminModule\Components\DataForm;
use Core\AdminModule\Model\Sites;
use EshopOrders\Model\EshopOrdersConfig;

class SettingsForm extends DataForm
{
	/** @var Sites|null @inject */
	public ?Sites $sitesService = null;

	public function getDataForInputs(): array
	{
		$data = parent::getDataForInputs();

		foreach ($this->sitesService->getOptionsForSelect() as $site) {
			$data[] = [
				'name'    => $site . 'ReviewInformationPage',
				'title'   => [
					0 => 'eshopOrders.settings.reviewInformationPage',
				],
				'type'    => 'navByGroup',
				'showIf'  => EshopOrdersConfig::load('enableReviewInformationPage', false),
				'site'    => $site,
				'section' => $site,
				'group'   => 'base',
				'groupName' => 'eshopOrders.settings.baseSettings',
			];
			$data[] = [
				'name'    => $site . 'PageAfterRegister',
				'title'   => [
					0 => 'eshopOrders.settings.customer.pageAfterRegister',
				],
				'type'    => 'navByGroup',
				'site'    => $site,
				'section' => $site
			];
		}

		return $data;
	}

}
