<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model\Dao;

use EshopOrders\Model\Entities\Order;

class OrderExpedition
{
	public Order   $order;
	public array   $siteColors       = [];
	public string  $serviceName;
	public ?object $expeditionEntity = null;

	public function __construct(
		Order   $order,
		string  $serviceName,
		?object $expeditionEntity = null
	)
	{
		$this->order            = $order;
		$this->serviceName      = $serviceName;
		$this->expeditionEntity = $expeditionEntity;
	}

	public function getOrderId(): int { return $this->order->getId(); }

	public function getCustomerName(): string
	{
		$address = $this->order->getAddressInvoice();

		return trim($address->getFirstName() . ' ' . $address->getLastName());
	}

	public function getCustomerCity(): string
	{
		$address = $this->order->getAddressDelivery();

		return $address->getCity();
	}

	public function getSitePrimaryColor(): string { return $this->siteColors['primaryColor'] ?? '#000000'; }
}
