<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use Core\Model\Sites;
use EshopOrders\AdminModule\Components\AdminTools\IMarketingInfoFactory;
use EshopOrders\AdminModule\Components\AdminTools\MarketingInfo;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Security\Passwords;

class AdminToolsPresenter extends BasePresenter
{
	protected Sites $sites;

	public array $adminToolsUrlFiles = [];

	public function __construct(
		Sites $sites
	)
	{
		$this->sites = $sites;
	}

	public function renderDefault(): void
	{
		$this->template->adminToolsUrlFiles = $this->adminToolsUrlFiles;
	}

	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		if (!$this->getUser()->isAllowed('EshopCatalog:Admin:AdminTools', 'access')) {
			$this->error();
		}

		$this->setHeader('eshopOrders.title.adminTools', 'fa fa-tools');

		$password = new Passwords();
		$keys     = [];
		foreach ($this->sites->getSites() as $k => $site) {
			$domains = [];
			foreach ($site->getDomains() as $domain) {
				if (!$domain->getDomain()) {
					continue;
				}

				$domains[$domain->getLang()] = $domain->getDomain();
			}

			$keys[$site->getIdent()] = [
				'ident'   => $site->getIdent(),
				'domains' => $domains,
				'key'     => $password->hash(EshopOrdersConfig::load('cronUrlHash') . $site->getIdent()),
			];
		}

		$this->template->keys = $keys;
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentMarketingInfo(IMarketingInfoFactory $factory): MarketingInfo
	{
		return $factory->create();
	}
}

