<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Expedition\ILogListFactory;
use EshopOrders\AdminModule\Components\Expedition\IOrdersGridFactory;
use EshopOrders\AdminModule\Components\Expedition\LogList;
use EshopOrders\AdminModule\Components\Expedition\OrdersGrid;

class ExpeditionPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopOrders.menu.expedition', 'fas fa-truck-loading');
	}

	public function handleUpdate(): void
	{
		$this->redrawControl('orders');
		$this->redrawControl('log');
	}

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
		]]);

		$this['ordersForExpedition']->onRedraw[] = function() { $this->redrawControl('log'); };
	}

	protected function createComponentOrdersForExpedition(IOrdersGridFactory $factory): OrdersGrid { return $factory->create(); }

	protected function createComponentLogList(ILogListFactory $factory): LogList { return $factory->create(); }
}
