<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use Core\Model\Sites;
use Core\Model\Templating\Filters\Price;
use EshopOrders\AdminModule\Model\DataConverter;
use EshopOrders\AdminModule\Model\Orders;
use EshopOrders\AdminModule\Model\Pdfs;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Pdf\IDeliveryListPdfBuilderFactory;
use EshopOrders\Model\Pdf\IInvoicePdfBuilderFactory;
use Nette\Application\ForbiddenRequestException;

class OrdersPresenter extends BasePresenter
{
	public DataConverter                  $dataConverter;
	public Orders                         $ordersService;
	public IDeliveryListPdfBuilderFactory $deliveryListBuilder;
	public IInvoicePdfBuilderFactory      $invoicePdfBuilder;

	public function __construct(
		DataConverter                  $dataConverter,
		Orders                         $ordersService,
		IDeliveryListPdfBuilderFactory $deliveryListBuilder,
		IInvoicePdfBuilderFactory      $invoicePdfBuilder
	)
	{
		$this->dataConverter       = $dataConverter;
		$this->ordersService       = $ordersService;
		$this->deliveryListBuilder = $deliveryListBuilder;
		$this->invoicePdfBuilder   = $invoicePdfBuilder;
	}

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
		]]);
	}

	public function actionInvoice(int $orderId): void
	{
		$order = $this->ordersService->get($orderId);

		if (!$order) {
			throw new ForbiddenRequestException();
		}

		$invoice = $this->invoices->getOneByOrder($order, true);

		$this->invoicePdfBuilderFactory->create($invoice)->render();
		exit;
	}

	public function actionPrint(array $ids): void
	{
		Price::$forceDecimals = 2;
		$data                 = $this->dataConverter->forPrint($ids);

		$this->template->statuses = $data['statuses'];
		$this->template->orders   = $data['orders'];
		$this->template->vatTotal = $data['vatTotal'];
	}

	public function actionPrintDeliveryList(array $ids): void
	{
		$lang = $this->getParameter('lang');

		if ($lang) {
			Sites::$currentLangOverride = $lang;
			$this->langsService->setDefault($lang);
			$this->translator->setLocale($lang);
		}

		if (!EshopOrdersConfig::load('enableDeliveryListPrint')) {
			throw new ForbiddenRequestException();
		}

		$this->deliveryListBuilder->create($ids)->render();
		$this->terminate();
	}
}
