<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use Core\Model\Countries;
use EshopOrders\AdminModule\Components\Payment\IPaymentsGridFactory;
use EshopOrders\AdminModule\Components\Payment\PaymentsGrid;
use EshopOrders\AdminModule\Components\PaymentSpedition\IPaymentSpeditionsGridFactory;
use EshopOrders\AdminModule\Components\PaymentSpedition\PaymentSpeditionsGrid;
use EshopOrders\AdminModule\Components\Spedition\ISpeditionsGridFactory;
use EshopOrders\AdminModule\Components\Spedition\SpeditionsGrid;
use EshopOrders\AdminModule\Model\Speditions;

class PaymentSpeditionPresenter extends BasePresenter
{
	protected Speditions $speditions;
	protected Countries  $countries;

	public function __construct(
		Speditions $speditions,
		Countries  $countries
	)
	{
		$this->speditions = $speditions;
		$this->countries  = $countries;

		parent::__construct();
	}

	protected function startup(): void
	{
		parent::startup();
		$this->setHeader('eshopOrders.menu.paymentSpedition', 'fa fa-truck');
	}

	public function actionDefault(?string $country = null): void
	{
		$assignedCountries = array_intersect_key($this->countries->getDao(), array_flip($this->speditions->getAllAssignedCountries()));

		$this->template->currentCountry    = $country;
		$this->template->assignedCountries = $assignedCountries;

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopOrders.menu.addPayment',
				'link'  => $this->link('paymentsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			], [
				'title' => 'eshopOrders.menu.addSpedition',
				'link'  => $this->link('speditionsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			], [
				'title' => 'eshopOrders.menu.addPaymentSpedition',
				'link'  => $this->link('paymentSpeditionsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	protected function createComponentPaymentsGrid(IPaymentsGridFactory $factory): PaymentsGrid
	{
		return $factory->create($this->getParameter('country') ?: null);
	}

	protected function createComponentSpeditionsGrid(ISpeditionsGridFactory $factory): SpeditionsGrid
	{
		return $factory->create($this->getParameter('country') ?: null);
	}

	protected function createComponentPaymentSpeditionsGrid(IPaymentSpeditionsGridFactory $factory): PaymentSpeditionsGrid
	{
		return $factory->create($this->getParameter('country') ?: null);
	}
}
