<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\ISettingsFormFactory;
use EshopOrders\AdminModule\Components\SettingsForm;
use EshopOrders\AdminModule\Components\Statuses\IStatusesGridFactory;
use EshopOrders\AdminModule\Components\Statuses\StatusesGrid;

class SettingsPresenter extends BasePresenter
{
	public function actionDefault(): void
	{
		$this->setHeader('eshopOrders.title.ordersSettings', 'fas fa-cogs');
	}

	protected function createComponentStatusesGrid(IStatusesGridFactory $factory): StatusesGrid { return $factory->create(); }

	protected function createComponentSettingsForm(ISettingsFormFactory $factory): SettingsForm
	{
		return $factory->create('eshopOrders');
	}
}

