<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopCatalog\AdminModule\Model\Suppliers;
use EshopOrders\AdminModule\Components\SupplierToOrder\ISupplierGridFactory;
use Nette\Application\UI\Multiplier;

class SupplierToOrderPresenter extends BasePresenter
{
	protected Suppliers $suppliers;

	public function __construct(
		Suppliers $suppliers
	)
	{
		$this->suppliers = $suppliers;
	}

	protected function startup(): void
	{
		parent::startup();
		$this->setHeader('eshopOrders.menu.supplierToOrder', 'fas fa-truck-loading');
	}

	public function actionDefault(): void
	{
		$this->template->suppliers = $this->suppliers->getOptionsForSelect();

		$this['navigation']->setData(['header' => [
		]]);
	}

	protected function createComponentSuppliersGrid(ISupplierGridFactory $factory): Multiplier
	{
		return new Multiplier(function(string $supplierId) use ($factory) {
			return $factory->create((int) $supplierId);
		});
	}
}
