<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\BodyEntity;

use Apitte\Core\Exception\Api\ClientErrorException;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Mapping\Request\BasicEntity;
use Nette\Utils\Json;
use Nette\Utils\JsonException;

class CartItem extends BasicEntity
{
	public ?string $itemId    = null;
	public ?int    $productId = null;
	public int     $quantity  = 1;
	public ?string $name      = null;
	public ?string $image     = null;
	public ?float  $price     = null;
	public array   $moreData  = [];
	public ?string $note      = null;
	public array   $files     = [];

	protected function fromBodyRequest(ApiRequest $request): self
	{
		try {
			$body  = (array) $request->getParsedBody();
			$files = array_key_exists('files', $body) ? $body['files'] : [];

			if (isset($body['values'])) {
				$body = Json::decode($body['values'], Json::FORCE_ARRAY);
			}


			$files         = array_merge($files, $request->getUploadedFiles());
			$body['files'] = $files;
		} catch (JsonException $ex) {
			throw new ClientErrorException('Invalid json data', 400, $ex);
		}

		return $this->factory($body ?? []);
	}
}
