<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopOrders\Model\PriceCalculator\PriceCalculatorItem;
use Gallery\FrontModule\Model\Dao\Image;

class CartItem
{
	public int      $id;
	public ?string  $ident               = null;
	public ?int     $productId           = null;
	public int      $quantity            = 1;
	public ?Product $product             = null;
	public ?float   $price               = null;
	public ?float   $priceInBaseCurrency = null;

	/** @var Image */
	public $image;

	public ?string  $link                          = null;
	public ?string  $title                         = null;
	protected ?int  $vatRate                       = null;
	public bool     $freeDelivery                  = false;
	public bool     $discountDisabled              = false;
	public bool     $disableCalculateFreeSpedition = false;
	protected array $data                          = [];
	protected array $gifts                         = [];

	/** @var self[] */
	protected array $childs = [];

	public ?int $parentId  = null;
	public int  $verifyAge = 0;

	/** Grams */
	public int $weight = 0;

	public ?PriceCalculatorItem $priceCalculatorItem = null;

	public function __construct(
		string $title,
		?int   $productId,
		float  $price
	)
	{
		$this->title     = $title;
		$this->productId = $productId;
		$this->price     = $price;
	}

	public function getId(): int { return $this->id; }

	public function setId(int $id): self
	{
		$this->id = $id;

		return $this;
	}

	public function getProductId(): ?int { return $this->productId; }

	public function setProductId(int $productId): self
	{
		$this->productId = $productId;

		return $this;
	}

	public function getQuantity(): int { return $this->quantity; }

	// TODO predelat do priceCalculatorItem? nebo uplne odebrat a dat do construtoru?
	public function setQuantity(int $quantity): self
	{
		$this->quantity = $quantity;

		return $this;
	}

	public function getProduct(): ?Product { return $this->product; }

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	/** @return null|Image */
	public function getImage() { return $this->image; }

	public function setImage(Image $image): self
	{
		$this->image = $image;

		return $this;
	}

	public function getLink(): ?string { return $this->link; }

	public function setLink(string $link): self
	{
		$this->link = $link;

		return $this;
	}

	public function getPrice(): float
	{
		$price = $this->priceCalculatorItem->getPriceWithVat();

//		foreach ($this->getChilds() as $child) {
//			$price = $price->plus(((int) $child->getData('baseQuantity') ?: $child->getQuantity()) * $child->getPrice());
//		}

		return $price->getAmount()->toFloat();
	}

	public function getPriceWithoutVat(): float
	{
		$price = $this->priceCalculatorItem->getPriceWithoutVat();

//		foreach ($this->getChilds() as $child) {
//			$price = $price->plus(((int) $child->getData('baseQuantity') ?: $child->getQuantity()) * $child->getPriceWithoutVat());
//		}

		return $price->getAmount()->toFloat();
	}

	// TODO predelat
	public function setPrice(float $price): self
	{
		$this->price = $price;

		return $this;
	}

	/**
	 * Pouze pro vypocet slev!
	 */
	public function getTotalPriceForDiscountsInBaseCurrency(): float
	{
		$item = new PriceCalculatorItem(
			$this->title,
			$this->priceInBaseCurrency,
			$this->quantity,
			$this->vatRate,
			$this->priceCalculatorItem->getPriceWithVat()->getCurrency()->getCurrencyCode(),
			$this->discountDisabled
		);

		return $item->getTotalWithVat()->getAmount()->toFloat();
	}

	public function getTotalPrice(): float
	{
		$price = $this->priceCalculatorItem->getTotalWithVat();

//		foreach ($this->getChilds() as $child) {
//			$price = $price->plus(((int) $child->getData('baseQuantity') ?: $child->getQuantity()) * $child->getPrice());
//		}

		return $price->getAmount()->toFloat();
	}

	public function getTotalPriceWithoutVat(): float
	{
		$price = $this->priceCalculatorItem->getTotalWithoutVat();

//		foreach ($this->getChilds() as $child) {
//			$price = $price->plus(((int) $child->getData('baseQuantity') ?: $child->getQuantity()) * $child->getPriceWithoutVat());
//		}

		return $price->getAmount()->toFloat();
	}

	public function setData(array $arr): self
	{
		$this->data = $arr;

		return $this;
	}

	/** @param mixed $value */
	public function addData(string $key, $value): self
	{
		$this->data[$key] = $value;

		return $this;
	}

	/**
	 * @param mixed|null $default
	 *
	 * @return mixed
	 */
	public function getData(?string $key = null, $default = null)
	{
		if ($key) {
			return $this->data[$key] ?? $default;
		}

		return $this->data;
	}

	public function getVatRate(): int { return $this->vatRate; }

	// TODO predelat do priceCalculatorItem? nebo uplne odebrat a dat do construtoru?
	public function setVatRate(int $vatRate): self
	{
		$this->vatRate = $vatRate;

		return $this;
	}

	public function getUploadedFilesDir(): string { return UPLOADS_DIR . DS . 'eshoporders-cart-uploads' . DS . $this->id; }

	public function getUploadedFiles(): array
	{
		$files = [];

		foreach (glob($this->getUploadedFilesDir() . DS . '*') ?: [] as $file) {
			$files[] = str_replace(WWW_DIR, '', $file);
		}

		return $files;
	}

	/****************
	 * == Gifts
	 */

	/** @return CartItemGift[] */
	public function getGifts(): array { return $this->gifts; }

	public function addGift(CartItemGift $gift): self
	{
		$this->gifts[] = $gift;

		return $this;
	}

	public function addChild(CartItem $item): void
	{
		$this->childs[$item->id] = $item;
		$item->parentId          = $this->id;
	}

	public function getChilds(): array { return $this->childs; }

	/** @param string|int $k */
	public function removeChild($k): void { unset($this->childs[$k]); }

	/** Grams */
	public function getTotalWeight(): int
	{
		return $this->weight ? $this->weight * $this->quantity : 0;
	}
}
