<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;

class Gift
{
	public int      $id;
	public ?int     $productId   = null;
	public ?Product $product     = null;
	public ?string  $name        = null;
	public ?string  $code1       = null;
	public ?string  $ean         = null;
	public ?string  $description = null;
	public ?float   $priceFrom   = null;

	public function __construct(
		int    $id,
		string $name
	)
	{
		$this->id   = $id;
		$this->name = $name;
	}
}
