<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Affiliate;

use Core\Model\Entities\TIdUnsigned;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Random;

/**
 * @ORM\Table("eshop_orders__affiliate_partner")
 * @ORM\Entity
 */
class AffiliatePartner
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	public string $name;

	/**
	 * @ORM\Column(name="ident", type="string", nullable=true, unique=true)
	 */
	public string $ident;

	/**
	 * @ORM\Column(name="created", type="datetime", nullable=false, options={"default":"CURRENT_TIMESTAMP"})
	 */
	public DateTime $created;

	/**
	 * @var ArrayCollection<AffiliateCampaign>
	 * @ORM\OneToMany(targetEntity="AffiliateCampaign", mappedBy="partner")
	 */
	public Collection $campaigns;

	/**
	 * @ORM\Column(name="default_commission", type="integer", nullable=false, options={"default":0})
	 */
	public int $defaultCommission = 0;

	/**
	 * @ORM\Column(name="hash", type="string", length=255, nullable=false)
	 */
	public string $hash;

	public function __construct(string $name, string $ident)
	{
		$this->name      = $name;
		$this->ident     = $ident;
		$this->created   = new DateTime();
		$this->campaigns = new ArrayCollection();
		$this->hash      = Random::generate(12);
	}
}

