<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Users\Model\Security\User;

class ExpeditionLogger
{
	protected EntityManagerDecorator $em;
	protected User                   $user;

	public function __construct(
		EntityManagerDecorator $em,
		User                   $user
	)
	{
		$this->em   = $em;
		$this->user = $user;
	}

	public function logError(string $serviceName, string $message, int $orderId, int $userId = null): void
	{
		if (!$userId) {
			$userId = $this->user->getIdentity()->getId();
		}

		$this->em->getConnection()->insert('eshop_orders__order_expedition_log', [
			'order_id'   => $orderId,
			'service'    => $serviceName,
			'status'     => 'error',
			'message'    => $message,
			'created_by' => $userId,
		]);
	}
}
