<?php declare(strict_types = 1);

namespace EshopOrders\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use EshopOrders\Model\Orders;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Order extends BaseNavigation implements INavigationItem
{
	protected $title     = 'order';
	protected $presenter = 'EshopOrders:Front:Default';
	protected $action    = 'order';

	/** @var Orders|null @inject */
	public ?Orders $ordersService = null;

	/**
	 * @param BaseForm $baseForm
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;

		return false;
	}

	public function routerIn($navigation, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		$urlParts = [];
		if (!$navigation->isHomepage)
			$urlParts[] = $navigation->alias;

		return '/' . implode('/', $urlParts);
	}

}
