<?php declare(strict_types = 1);

namespace EshopOrders\Model\PriceCalculator;

use Brick\Math\RoundingMode;
use Brick\Money\Money;

class PriceCalculatorDiscount
{
	protected string $type;
	protected Money  $value;
	protected string $currency;

	public function __construct(string $type, float $value, string $currency)
	{
		if (!in_array($type, ['fix', 'percent'])) {
			$type = 'fix';
		}

		$this->type     = $type;
		$this->currency = $currency;
		$this->value    = Money::of($value, $currency, null, RoundingMode::HALF_UP);
	}

	public function getType(): string
	{
		return $this->type;
	}

	public function getValue(): Money
	{
		return $this->value;
	}

	public function fixValue(bool $isODD = false): void
	{
		$value = $this->getValue()->getAmount()->abs()->toFloat();

		if (!$isODD) {
			$value = -($value);
		}

		$this->value = Money::of($value, $this->currency, null, RoundingMode::HALF_UP);
	}
}
