<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Components\Widget;
use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;
use Core\Model\Templating\Filters\Price as PriceFilter;

class OrdersSales extends Widget implements IWidget
{
	protected $gridSize = 'col-md-4 col-xxl-3';

	protected $key = 'eshopOrdersOrdersSales';

	/** @var Statistics\Overview @inject */
	public $overview;

	/** @var PriceFilter @inject */
	public $priceFilter;

	public function render()
	{
		$this->template->key   = $this->key;
		$this->template->icon  = 'fas fa-coins';
		$this->template->title = $this->t('eshopOrders.dashboardWidget.sales.title');

		$data                    = $this->overview->getOrdersSales();
		$this->template->value   = $this->priceFilter->format((float) $data['count']);
		$this->template->percent = $data['percent'];

		$this->template->baseTemplate = __DIR__ . '/baseCount.latte';
		$this->template->render($this->getTemplateFile());
	}
}
