<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopOrders\Model\Orders;
use EshopOrders\Model\OrderStatuses;

class OrderStatusesGrid extends BaseControl
{
	/** @var Orders */
	protected $ordersService;

	/** var OrderStatuses */
	protected $orderStatusesService;

	private $orderId;

	public function __construct(Orders $orders, OrderStatuses $orderStatuses)
	{
		$this->ordersService        = $orders;
		$this->orderStatusesService = $orderStatuses;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setItemsPerPageList([]);
		$grid->hideTableFooter();

		$qb = $this->orderStatusesService->getEr()->createQueryBuilder('os')
			->andWhere('os.order = :order')->setParameter('order', $this->ordersService->getReference($this->orderId))
			->orderBy('os.id', 'ASC');
		$grid->setDataSource($qb);

		//Columns
		$grid->addColumnText('statusName', 'eshopOrders.statusesGrid.statusName', 'status.name');
		$grid->addColumnDateTime('statusTime', 'eshopOrders.statusesGrid.statusTime', 'created')->setFormat('d.m.Y H:i');

		// Filter;

		// Columns prototype

		return $grid;
	}

	public function setOrder($id): self
	{
		$this->orderId = $id;

		return $this;
	}


	/*******************************************************************************************************************
	 * ==================  Handle
	 */


	/*******************************************************************************************************************
	 * =================  Grid function
	 */

}
