<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\Model\Invoices;
use EshopOrders\Model\Pdf\IInvoicePdfBuilderFactory;
use Mpdf\MpdfException;
use Nette\Application\BadRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/** @var Invoices @inject */
	public $invoices;

	/** @var IInvoicePdfBuilderFactory @inject */
	public $invoicePdfBuilderFactory;

	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access'))
			$this->error();
	}

	/**
	 * @param mixed $id
	 * @throws BadRequestException
	 * @throws MpdfException
	 */
	public function handlePdf($id): void
	{
		$invoice = $this->invoices->get((int) $id);

		if ($invoice === null) {
			$this->error();
		}

		$this->invoicePdfBuilderFactory->create($invoice)->render();
	}

}
