<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;


use Apitte\Core\Annotation\Controller\ControllerPath;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopOrders\AdminModule\Model\Customers;
use Users\Model\Security\User;

/**
 * Class CustomersController
 * @ControllerPath("/customers")
 */
class CustomersController extends BaseController
{
	/** @var User */
	protected $user;

	/** @var Customers */
	protected $customersService;

	public function __construct(User $userService, Customers $customersService)
	{
		$this->user             = $userService;
		$this->customersService = $customersService;
	}

	/**
	 * @Path("/")
	 * @Method("GET")
	 */
	public function index(ApiRequest $request, ApiResponse $response)
	{
		$customers = $this->customersService->getAll();
		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($customers));
	}
}

